### 实验名称

爬取链家房价信息信息存储并分析 - MongoDB 存储和聚合查询

### 实验目的

1、掌握 requests 和 lxml 库爬取网页及对网页的数据提取；

2、掌握 Python 连接 MongoDB，增删改查等；

3、掌握 Mongo 常用聚合函数；

4、熟悉 Python 进行数据分析并将数据可视化。

### 实验背景

MongoDB 是文档数据库，采用 BSON 的结构来存储数据。在文档中可嵌套其他文档类型，使得 MongoDB 具有很强的数据描述能力。

本节案例使用的数据为链家的租房信息，源数据来自于链家网站，所以首先要获取网页数据并解析出本案例所需要的房源信息，然后将解析后的数据存储到 MongoDB 中，最后基于这些数据进行城市租房信息的查询和聚合分析等。

**备注：**

1. 这个实验使用了爬虫技术，为了正常爬取数据，又不给链家网带来压力，已经尽量减少了请求的数量。
2. 由于各个公司对爬虫都有反爬措施，建议不要重复运行此实验，或是将本实验在本地运行。
3. 如果出现采集到的数据少于本实验截图，也是正常现象，链家网的反爬措施也在不断调整。

### 实验原理

使用爬虫爬取数据，如果采用关系型数据库的话，必须一开始就需要考虑建表，还经常面临字段长度溢出、需求改变、时刻需要关注表结构是否需要修改等等一系列问题。

而使用 Mongodb，在爬到数据后进行存储，只需要做两件事情：

1. 将数据整理成字典或 JSON 格式；
2. 使用 Python 将数据插入 MongoDB。

并且使用 MongoDB时，

1. 不需要设置表结构；
2. 数据插入简单；
3. 没有字段长度要求；
4. 可以设置 index，插入的时候避免重复，减少使用数据时清晰数据的工作量。

### 实验环境

Ubuntu18.04

Python3.9.17

MongoDB6.0.8

### 建议课时

1课时

### 实验步骤

一、实验准备
0. 启动 mongod 服务

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

   ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
   ```

   （2）执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork
   ```

1. 打开 Pycharm 开发工具，新建 Py 项目

   ![11-2-1-创建Py项目.png](./pic/11-2-1-创建Py项目.png)

   在打开的项目中，新建 Python 文件

   ![11-2-2-创建Py文件.png](./pic/11-2-2-创建Py文件.png)

   以下实验过程中所有 Python 代码均在 Pycharm 中编写。

2. 打开 Pycharm 的 Terminal，安装实验所需依赖

   ![11-2-4-安装依赖-1.png](./pic/11-2-4-安装依赖-1.png)

   （1）升级 pip 版本

   ```sh
   pip install --upgrade pip
   ```

   ![11-2-4-升级pip.png](./pic/11-2-4-升级pip.png)

   （2）安装依赖

   ```sh
   pip install requests # requests==2.27.1
   pip install lxml # lxml==4.9.3
   pip install pymongo # pymongo==4.1.1
   pip install matplotlib # matplotlib==3.3.4
   ```

   ![11-2-4-安装依赖-2.png](./pic/11-2-4-安装依赖-2.png)

   ![11-2-4-安装依赖-3.png](./pic/11-2-4-安装依赖-3.png)

   ![11-2-4-安装依赖-4.png](./pic/11-2-4-安装依赖-4.png)

二、使用 Python 爬取数据并存入 MongoDB

分析楼盘（新房）信息首先要获取原始的房源数据，本例使用 Python 爬虫技术获取链家网的楼盘（新房）信息，所有 Python 代码存放在 **pyloupan.py** 文件中。链家网的楼盘首页如图所示，本例中需要获取房源所在区域、小区名、房型、面积、具体位置、价格等信息。

![11-2-3-楼盘首页-1.png](./pic/11-2-3-楼盘首页-1.png)

![11-2-3-楼盘首页-2.png](./pic/11-2-3-楼盘首页-2.png)

1. 本例中使用 Python 的 requests 爬虫库从链家网站上获取各城市的楼盘（新房）信息，并用 lxml 库来解析网页上的数据。导入依赖的示例代码如下：

   ```js
   import requests
   import time
   from lxml import html
   from pymongo import MongoClient
   ```

2. 获取武汉市链家网的所有区域 url 地址：

   （1）定义 get\_areas() 函数

   该函数接受2个参数：url 为武汉市的链家网楼盘（新房）链接，本例中 url 为 “https://wh.fang.lianjia.com/loupan/”；col 为链接的 MongoDB 集合，本例 col 为 `col = db.get_collection("loupan")`。

   本函数主要完成解析武汉楼盘（新房） url 页面，使用 requests 库的 get() 方法获取网页内容，第一个参数为爬取的网页地址，第二个参数为 get() 请求的头 Headers。get() 方法返回的是 HTML 格式的网页内容，使用 lxml 库对 HTML 网页进行格式化，再对格式化后的网页内容使用 xpath 函数解析，从中获取到各个区域的信息，并拼接成武汉各个区域的楼盘（新房） url，然后调用 get\_pages() 函数。

   每行代码的含义通过**注释**描述出来，具体如下：

   ```python
   # 获取某市所有区域的链接
   def get_areas(url, col):
       print('start grabing areas...')
       # 设置请求头
       headers = {
           'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36'}
       # 获取请求页面数据
       res = requests.get(url, headers=headers)
       content = html.fromstring(res.text)
       # 获取各个区域信息
       areas = content.xpath('//div[@class="filter-by-area-container"]/ul[@class="district-wrapper"]/li/text()')
       print(areas)
   
       # 获取各个区域的链接
       areas_link = content.xpath(
           '//div[@class="filter-by-area-container"]/ul[@class="district-wrapper"]/li/@data-district-spell')
       print(areas_link)
   
       # 遍历获取所有区域的链接
       for i in range(0, len(areas)):
           area = areas[i]
           area_link = areas_link[i]
           print(area_link)
           # 拼接区域 url
           link = url + area_link
           print("开始抓取页面：" + link + " ...")
           get_pages(area, link, col)
   ```

3. 获取所在区域的某页面 url

   定义 get\_pages() 函数，该函数接受3个参数：area 为某区域的汉语全拼，如 hannan；area\_link 为链家网武汉市某区域链接，这个链接是可变的，本例中 area\_link 可以为 “https://wh.fang.lianjia.com/loupan/hannan”； col 为链接的 MongoDB 集合，本例 col 为 `col = db.get_collection("loupan")`。

   本函数主要完成解析武汉楼盘（新房）某区域 url 页面，使用 requests 库的 get() 方法获取网页内容，第一个参数为爬取的网页地址，第二个参数为 get() 请求的头 Headers。get() 方法返回的是 HTML 格式的网页内容，使用 lxml 库对 HTML 网页进行格式化，再对格式化后的网页内容使用 xpath 函数解析，从中获取到各个区域楼盘（新房）信息的页面数量，拼接成武汉各个区楼楼盘对应页的 url，然后调用 get\_house\_info() 函数。

   每行代码的含义通过**注释**描述出来，具体如下：

   ```python
   # 通过获取某一区域的页数，来拼接该区域某一页的链接
   def get_pages(area, area_link, col):
       headers = {
           'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36'}
       res = requests.get(area_link, headers=headers)
       content = html.fromstring(res.text)
       try:
           # 链家新房页面统计每个区域的楼盘个数
           count = int(content.xpath('//div[@class ="page-box"]/@data-total-count')[0])
           # 转换成页面，获取每个页面的楼盘信息
   
           if count % 10:
               pages = count // 10 + 1
           else:
               pages = count // 10
           print("这个区域共有" + str(pages) + "页")
           # 抓取所有页面，但会导致链家请求压力的增加
           # for page in range(1, pages+1):
           # 只抓取1页，多了会被屏蔽，为了减小链家请求的压力
           for page in range(1, 2):
               url = area_link + '/pg' + str(page) + '/#' + area
               # 获取页面信息
               print(url)
               print("开始抓取第" + str(page) + "页的信息...")
   
               get_house_info(area, url, col)
       except Exception as e:
           print(e)
           time.sleep(20)
   ```

4. 获取某页面详细楼盘信息

   定义 get\_ house\_info() 函数，该函数接受3个参数：area 为某区域名称，如汉南；url 为链家网楼盘（新房）某市某区某个页面的链接，这个链接是可变的，本例中 url可以为 “https://wh.fang.lianjia.com/loupan/hannan/pg1/#hannan”； col 为链接的 MongoDB 集合，本例 col 为 `col = db.get_collection("loupan")`。

   本函数主要完成解析武汉楼盘（新房）某区某个页面详情页，页面详情页包含有需要爬取的数据，如图所示：

   ![11-2-5-某区某页房源信息-1.png](./pic/11-2-5-某区某页房源信息-1.png)

   ![11-2-5-某区某页房源信息-2.png](./pic/11-2-5-某区某页房源信息-2.png)

   使用 requests 库的 get() 方法获取网页内容，第一个参数为爬取的网页地址，第二个参数为 get() 请求的头 Headers。get() 方法返回的是 HTML 格式的网页内容，使用 lxml 库对 HTML 网页进行格式化。再对格式化后的网页内容使用 xpath 函数解析，从中获取到某区楼盘的具体信息，并插入到 MongoDB 的集合中。

   每行代码的含义通过**注释**描述出来，具体如下：

   ```python
   # 获取某一区域某一页的详细租房信息
   def get_house_info(area, url, col):
       hlist = []
       headers = {
           'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36'}
       # 休息10s，单次爬取要间隔时间长些，避免给服务器带来太大的压力
       time.sleep(10)
       try:
           res = requests.get(url, headers=headers)
           content = html.fromstring(res.text)
   
           # 链家每一个页面默认10条信息
           for i in range(10):
               try:
                   # 获取小区名称
                   title = content.xpath("//ul[@class='resblock-list-wrapper']/li/a/@title")[i]
                   print(title)
                   # 获取小区位置信息
                   detail_area = content.xpath(
                       "//ul[@class='resblock-list-wrapper']/li//div[@class='resblock-location']/span[2]/text()")[i]
                   print(detail_area)
                   # 获取详细地址信息
                   detail_place = \
                       content.xpath("//ul[@class='resblock-list-wrapper']/li//div[@class='resblock-location']/a/text()")[
                           i]
                   print(detail_place)
                   # 获取小区类型
                   type = \
                       content.xpath(
                           "//ul[@class='resblock-list-wrapper']/li//div[@class='resblock-name']/span[1]/text()")[i]
                   print(type)
                   # 获取房屋面积
                   try:
                       square = \
                           content.xpath(
                               "//ul[@class='resblock-list-wrapper']/li//div[@class='resblock-area']/span/text()")[i]
                   except Exception as e:
                       square = ""
                   print(square)
                   # 获取房屋价格
                   price = \
                       content.xpath("//ul[@class='resblock-list-wrapper']/li//div[@class='main-price']/span[1]/text()")[i]
                   # 价格待定的楼盘设置price为0
                   if price == '价格待定':
                       price = 0
                   print(price)
   
                   item = {
                       "area": area,
                       "title": title,
                       "type": type,
                       "square": square,
                       "detail_area": detail_area,
                       "detail_place": detail_place,
                       "price": int(price),
                   }
                   # 追加到列表
                   hlist.append(item)
               except Exception as e:
                   break
           print('writing work has done! continue the next page...')
           # 批量插入 MongoDB 数据库
           col.insert_many(hlist)
       except Exception as e:
           print(res.text)
           print(url)
           print('ooops! connecting error, retrying...')
           time.sleep(20)
   ```

5. 连接数据库并爬取数据

   定义 main() 函数，用于链接数据库并开始爬取数据。

   本例中爬取城市武汉的楼盘（新房）信息，数据库名称为 “lianjia”，集合名称为 “loupan”，如需其他城市信息可自行设置 URL。实际编程过程中可将部分代码提取出方法，方便使用，而且使代码更简洁，易读。

   每行代码的含义通过**注释**描述出来，具体如下：

   ```python
   def main():
       print('start!')
       # 需要爬取的 url
       url = 'https://wh.fang.lianjia.com/loupan/'
       # 设置 mongo 数据库
       client = MongoClient('127.0.0.1', 27017)
       db = client.get_database("lianjia")
       # 每次运行先删除原集合，保证数据不被污染
       db.get_collection("loupan").drop()
       col = db.get_collection("loupan")
   
       get_areas(url, col)
   
   
   if __name__ == '__main__':
       main()
   ```

6. 运行 **pyloupan.py**，输出如下：

   ![11-2-6-pyloupan输出-1](./pic/11-2-6-pyloupan输出-1.png)

   ![11-2-6-pyloupan输出-2](./pic/11-2-6-pyloupan输出-2.png)

7. 获取房源信息后，文档的存储格式

   ![11-2-7-存储格式.png](./pic/11-2-7-存储格式.png)

   \_id 由系统自动生成，所在区域 area、小区名称 title、住房类型 type 等为字符串形式，价格为浮点数。

三、Python 连接 MongoDB，并实现可视化操作

房源数据进行存储后，需要进行数据分析，比如获取每个区域房价的平均值和最大值，并以条形图的形式展示出来，所有 Python 代码存放在 **pypyfenx.py** 文件中。

1. Python 连接数据库需要使用到 pymong 库，其中连接数据库和创建集合的代码片段如下：

   ```python
   from pymongo import MongoClient
   import matplotlib.pyplot as plt
   from matplotlib.font_manager import *
   import matplotlib
   
   # 设置可视化组件类型
   matplotlib.use('TkAgg')
   
   # 连接 MongoDB 数据库
   client = MongoClient('127.0.0.1', 27017)
   db = client.get_database("lianjia")
   col = db.get_collection("loupan")
   ```

   使用 MongoClient 类创建连接数据库对象 client，本案例使用：

   本地数据库127.0.0.1:27017；

   get\_database 方法连接数据库；

   参数 lianjia 为数据库名；

   get\_collection 方法连接集合；

   参数 loupan 为集合名称，如果不存在此数据库和集合则新建。

2. 计算展示匹配楼盘类型为住宅，且已给出房价的楼盘信息

   （1）基于 MongoDB 聚合管道技术对数据进行分组计算，对房源的区域进行分组聚合，并过滤掉房价待定且不是住宅用途的楼盘，具体代码如下：

   ```python
   # 设置 match 和 group 分组聚合管道得到城市每个区域住房的房价信息
   print("-" * 20)
   # 过滤掉房价待定且不是住宅用途的楼盘
   pipeline = [
   
       {"$match":
           {
               "type": "住宅",
               "price": {"$ne": 0}
           }
       },
       {"$group":
           {
               "_id": "$area",
               "avgPrice": {"$avg": "$price"},
               "MaxPrice": {"$max": "$price"}
           }
       },
   ]
   data = col.aggregate(pipeline)
   for item in data:
       print(item)
   print("-" * 20)
   ```

   （2）运行 **pyfenxi.py**，输出如下：

   ![11-2-8-pyfenxi输出-1.png](./pic/11-2-8-pyfenxi输出-1.png)

   从输出结果可以看出不同区的楼盘最高和平均值还是有较大差别的，为更好的展示分析结果，下面对数据进行可视化操作。

3. 分析并可视化

   （1）基于聚合统计出的数据使用 python 绘制条形图，使用到 matplotlib 库，具体代码如下：

   ```python
   # 进行聚合计算操作
   lists = col.aggregate(pipeline)
   label_list = []
   num_list1 = []
   num_list2 = []
   
   # 获取聚合后的数据并插入label_list ，num_list1，num_list2，用于纵横坐标显示。
   for list in lists:
       label_list.append(list['_id'])
       num_list1.append(round(list['avgPrice'], 1))
       num_list2.append(list['MaxPrice'])
   
   # 设置中文字体和负号正常显示
   
   myfont = FontProperties(fname='/usr/share/fonts/truetype/wqy/wqy-zenhei.ttc')  # 解决中文乱码
   
   matplotlib.rcParams['axes.unicode_minus'] = False  # 解决正负号问题
   
   x = range(len(num_list1))
   
   # 绘制条形图 :条形中点横坐标；height:长条形高度；width:长条形宽度，默认值0.8；label:为后面设置 legend 准备
   rects1 = plt.bar(x, height=num_list1, width=0.4, alpha=0.8, color='red', label="average")
   rects2 = plt.bar([i + 0.4 for i in x], height=num_list2, width=0.4, color='green', label="highest")
   plt.ylim(0, max(num_list2) + 1000)  # y 轴取值范围
   plt.ylabel(u"价格", fontproperties=myfont)
   
   # 设置 x 轴刻度显示值；参数一：中点坐标；参数二：显示值
   plt.xticks([index + 0.2 for index in x], label_list, fontproperties=myfont)
   plt.xlabel(u"区域", fontproperties=myfont)
   plt.title(u"武汉地区房价", fontproperties=myfont)
   plt.legend()  # 设置题注
   
   for rect in rects1:
       height = rect.get_height()
       plt.text(rect.get_x() + rect.get_width() / 2, height + 1, str(height), ha="center", va="bottom",
                fontproperties=myfont)
   for rect in rects2:
       height = rect.get_height()
       plt.text(rect.get_x() + rect.get_width() / 2, height + 1, str(height), ha="center", va="bottom",
                fontproperties=myfont)
   # 显示条形图
   plt.show()
   # 关闭数据库连接
   client.close()
   ```

   （2）运行 **pyfenxi.py**，得到的可视化结果如下：

   ![11-2-8-pyfenxi输出-2.png](./pic/11-2-8-pyfenxi输出-2.png)

四、附代码

1. 完整爬取链家新房楼盘信息、存入 MongoDB 数据库并进行可视化展示的代码地址：

   ```python
   wget http://10.90.3.2/LMS/DataMining/shixun/pyloupan.py
   wget http://10.90.3.2/LMS/DataMining/shixun/pyfenxi.py
   ```

### 实验总结

该实验的主要内容是使用 Python 编写爬虫代码进行获取链家的租房信息，首先要获取网页数据并解析出所需要的房源信息，然后将解析后的数据存储到 MongoDB 中，最后基于这些数据进行城市租房信息的查询和聚合分析等，最后通过数据可视化库 matplotlib 将聚合分析的数据进行可视化。通过实验能够熟悉 Python 编写爬虫的基本原理，熟悉 lxml 解析页面数据的方法。掌握了将爬取的数据存储到 MongoDB 的原理，能够使用 matplotlib 进行数据可视化。

需要**注意**的是，由于网站的反爬措施，最终爬取下来的数据可能有所不同。